using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using gov.va.med.vbecs.Common;
using System.Windows.Forms;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// frmRecordPhenotyeResults UI form, allows user to select units and record unit antigen typing tests.
		///</summary>

		#endregion


	public class FrmRecordPhenotypeResults : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		//
		private BOL.AntiseraWorklist _antiseraWorklist;
		private DataTable _dtAntiseraWorklistTypings;
		private DataTable _dtUnits;
		private ArrayList _dsPhenotypeGrids;
		private int _activeReagent;
		private DataRow _drAntiseraWorklistTyping;
		private Hashtable _taskStatus;
		private System.Guid [] _bloodUnitGuids = null;
		private Guid _antiDControlGuid;
		private string _antiDControlComment;
		private bool _changesSaved = false;
		
		private ArrayList _alWorkloadProcessIds;
		//
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.TabPage tabPage2;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpKey;
		private System.Windows.Forms.Label lblError;
		private System.Windows.Forms.Label lblE;
		private System.Windows.Forms.Label lblWarning;
		private System.Windows.Forms.Label lblValid;
		private System.Windows.Forms.Label lblW;
		private System.Windows.Forms.Label lblV;
		private System.Windows.Forms.GroupBox grpValidEntries;
		private System.Windows.Forms.Label lblValidEntries;
		private System.Windows.Forms.Panel pnlWorklistBuilder;
		private System.Windows.Forms.Panel pnlPhenotype;
		private System.Windows.Forms.TabControl tabAntisera;
		private System.Windows.Forms.Panel pnlAntiseraResults;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.WorklistBuilder worklistBuilder1;
		private System.Windows.Forms.PrintDialog printDialog1;
		private gov.va.med.vbecs.GUI.controls.DataGridUnitPhenotype dgPhenotype;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// FrmRecordPhenotypeResults constructor. Displays unit selection panel first.
		/// </summary>
		/// <param name="antiseraWorklist">Antisera Worklist</param>
		/// <param name="dtAntiseraWorklistTypings">Antisera Worklist Typing data table</param>
		/// <param name="antiDControlGuid"></param>
		/// <param name="antiDControlComment"></param>
		public FrmRecordPhenotypeResults(BOL.AntiseraWorklist antiseraWorklist, DataTable dtAntiseraWorklistTypings, Guid antiDControlGuid, string antiDControlComment)
		{
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.pnlWorklistBuilder.Visible = true;
			this.pnlPhenotype.Visible = false;
			//
			_dtAntiseraWorklistTypings = dtAntiseraWorklistTypings;
			this._antiDControlGuid = antiDControlGuid;
			this._antiDControlComment = antiDControlComment;
			//
			this._antiseraWorklist = antiseraWorklist;
			this.dgPhenotype.TestingDate = this._antiseraWorklist.WorklistCreateDate;
			//				this._antiseraWorklist.LastUpdateFunctionId = Common.UpdateFunction.UC041FrmRecordPhenotypeResults;
			//
		}

		/// <summary>
		/// FrmRecordPhenotypeResults constructor, includes units. Displays result grids.
		/// </summary>
		/// <param name="antiseraWorklist">Antisera Worklist</param>
		/// <param name="dtAntiseraWorklistTypings">Antisera Worklist Typing data table</param>
		/// <param name="dtUnits">Blood Units data table</param>
		public FrmRecordPhenotypeResults(BOL.AntiseraWorklist antiseraWorklist, DataTable dtAntiseraWorklistTypings, DataTable dtUnits)
		{
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.pnlWorklistBuilder.Visible = false;
			this.pnlPhenotype.Visible = true;
			//
			this._antiseraWorklist = antiseraWorklist;
			this.dgPhenotype.TestingDate = this._antiseraWorklist.WorklistCreateDate;
			this._dtAntiseraWorklistTypings = dtAntiseraWorklistTypings;
			this._dtUnits = dtUnits;
	
			System.Data.DataTable dtLocks = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(this._antiseraWorklist.AntiseraWorklistGuid);
            this.CollectRecordGuidsForLocking(dtLocks);

			//Attempt to lock the UnitTests
			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}


			this._bloodUnitGuids = new System.Guid [this._dtUnits.Rows.Count];
			int nCtr= 0;
			foreach (DataRow dr in this._dtUnits.Rows)
			{
				System.Guid bloodUnitGuid = (System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid];
				this._bloodUnitGuids[nCtr] = bloodUnitGuid;
				nCtr ++;
			}

			//
			CreateTabs();
			ConfigureGridDisplay(dtUnits,true);
			//
			if (this.pnlAntiseraResults.Visible)
			{
				DataSet dsPhenotype = (DataSet)this._dsPhenotypeGrids[_activeReagent];
				if (Convert.ToInt32(this._drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
				{
				
					this.dgPhenotype.FocusWeakDGrid();
				}
				else
				{
					this.dgPhenotype.FocusPhenotypeGrid();
				}
			}
			//
			this.btnOK.EnabledButton = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmRecordPhenotypeResults));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.tabAntisera = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.tabPage2 = new System.Windows.Forms.TabPage();
			this.pnlAntiseraResults = new System.Windows.Forms.Panel();
			this.dgPhenotype = new gov.va.med.vbecs.GUI.controls.DataGridUnitPhenotype();
			this.grpKey = new System.Windows.Forms.GroupBox();
			this.lblError = new System.Windows.Forms.Label();
			this.lblE = new System.Windows.Forms.Label();
			this.lblWarning = new System.Windows.Forms.Label();
			this.lblValid = new System.Windows.Forms.Label();
			this.lblW = new System.Windows.Forms.Label();
			this.lblV = new System.Windows.Forms.Label();
			this.grpValidEntries = new System.Windows.Forms.GroupBox();
			this.lblValidEntries = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.pnlWorklistBuilder = new System.Windows.Forms.Panel();
			this.worklistBuilder1 = new gov.va.med.vbecs.GUI.controls.WorklistBuilder(this.components);
			this.pnlPhenotype = new System.Windows.Forms.Panel();
			this.printDialog1 = new System.Windows.Forms.PrintDialog();
			this.grpImage.SuspendLayout();
			this.tabAntisera.SuspendLayout();
			this.pnlAntiseraResults.SuspendLayout();
			this.grpKey.SuspendLayout();
			this.grpValidEntries.SuspendLayout();
			this.pnlWorklistBuilder.SuspendLayout();
			this.pnlPhenotype.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.TabIndex = 4;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 489);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 448);
			this.grpImage.TabIndex = 2;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(658, 480);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			this.btnCancel.MouseHover += new System.EventHandler(this.btnCancel_MouseHover);
			// 
			// tabAntisera
			// 
			this.tabAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabAntisera.Controls.Add(this.tabPage1);
			this.tabAntisera.Controls.Add(this.tabPage2);
			this.tabAntisera.Location = new System.Drawing.Point(56, 4);
			this.tabAntisera.Name = "tabAntisera";
			this.tabAntisera.SelectedIndex = 0;
			this.tabAntisera.Size = new System.Drawing.Size(686, 444);
			this.tabAntisera.TabIndex = 0;
			this.tabAntisera.SelectedIndexChanged += new System.EventHandler(this.tabAntisera_SelectedIndexChanged);
			// 
			// tabPage1
			// 
			this.tabPage1.Location = new System.Drawing.Point(4, 23);
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.Size = new System.Drawing.Size(678, 417);
			this.tabPage1.TabIndex = 0;
			this.tabPage1.Text = "Antisera1";
			// 
			// tabPage2
			// 
			this.tabPage2.Location = new System.Drawing.Point(4, 23);
			this.tabPage2.Name = "tabPage2";
			this.tabPage2.Size = new System.Drawing.Size(678, 413);
			this.tabPage2.TabIndex = 1;
			this.tabPage2.Text = "Antisera 2";
			// 
			// pnlAntiseraResults
			// 
			this.pnlAntiseraResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlAntiseraResults.Controls.Add(this.dgPhenotype);
			this.pnlAntiseraResults.Controls.Add(this.grpKey);
			this.pnlAntiseraResults.Controls.Add(this.grpValidEntries);
			this.pnlAntiseraResults.Location = new System.Drawing.Point(60, 28);
			this.pnlAntiseraResults.Name = "pnlAntiseraResults";
			this.pnlAntiseraResults.Size = new System.Drawing.Size(678, 416);
			this.pnlAntiseraResults.TabIndex = 1;
			// 
			// dgPhenotype
			// 
			this.dgPhenotype.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgPhenotype.EnableQCGrid = true;
			this.dgPhenotype.Location = new System.Drawing.Point(4, 0);
			this.dgPhenotype.Name = "dgPhenotype";
			this.dgPhenotype.Size = new System.Drawing.Size(670, 332);
			this.dgPhenotype.TabIndex = 0;
			this.dgPhenotype.TestingDate = new System.DateTime(((long)(0)));
			this.dgPhenotype.TestPhases = gov.va.med.vbecs.Common.ReactivityPhase.Unknown;
			this.dgPhenotype.CurrentCellChanged += new System.EventHandler(this.dgPhenotype_CurrentCellChanged);
			// 
			// grpKey
			// 
			this.grpKey.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.grpKey.Controls.Add(this.lblError);
			this.grpKey.Controls.Add(this.lblE);
			this.grpKey.Controls.Add(this.lblWarning);
			this.grpKey.Controls.Add(this.lblValid);
			this.grpKey.Controls.Add(this.lblW);
			this.grpKey.Controls.Add(this.lblV);
			this.grpKey.Location = new System.Drawing.Point(4, 332);
			this.grpKey.Name = "grpKey";
			this.grpKey.Size = new System.Drawing.Size(84, 80);
			this.grpKey.TabIndex = 1;
			this.grpKey.TabStop = false;
			this.grpKey.Text = "Key";
			// 
			// lblError
			// 
			this.lblError.Location = new System.Drawing.Point(28, 56);
			this.lblError.Name = "lblError";
			this.lblError.Size = new System.Drawing.Size(32, 20);
			this.lblError.TabIndex = 5;
			this.lblError.Text = "Error";
			this.lblError.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblE
			// 
			this.lblE.BackColor = System.Drawing.Color.Red;
			this.lblE.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblE.Location = new System.Drawing.Point(8, 56);
			this.lblE.Name = "lblE";
			this.lblE.Size = new System.Drawing.Size(16, 16);
			this.lblE.TabIndex = 4;
			this.lblE.Text = "E";
			this.lblE.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblWarning
			// 
			this.lblWarning.Location = new System.Drawing.Point(28, 36);
			this.lblWarning.Name = "lblWarning";
			this.lblWarning.Size = new System.Drawing.Size(49, 20);
			this.lblWarning.TabIndex = 3;
			this.lblWarning.Text = "Warning";
			this.lblWarning.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblValid
			// 
			this.lblValid.Location = new System.Drawing.Point(28, 16);
			this.lblValid.Name = "lblValid";
			this.lblValid.Size = new System.Drawing.Size(32, 20);
			this.lblValid.TabIndex = 1;
			this.lblValid.Text = "Valid";
			this.lblValid.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblW
			// 
			this.lblW.BackColor = System.Drawing.Color.Yellow;
			this.lblW.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblW.Location = new System.Drawing.Point(8, 36);
			this.lblW.Name = "lblW";
			this.lblW.Size = new System.Drawing.Size(16, 16);
			this.lblW.TabIndex = 2;
			this.lblW.Text = "W";
			this.lblW.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblV
			// 
			this.lblV.BackColor = System.Drawing.Color.Lime;
			this.lblV.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblV.CausesValidation = false;
			this.lblV.Location = new System.Drawing.Point(8, 16);
			this.lblV.Name = "lblV";
			this.lblV.Size = new System.Drawing.Size(16, 16);
			this.lblV.TabIndex = 0;
			this.lblV.Text = "V";
			this.lblV.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// grpValidEntries
			// 
			this.grpValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpValidEntries.Controls.Add(this.lblValidEntries);
			this.grpValidEntries.Location = new System.Drawing.Point(92, 332);
			this.grpValidEntries.Name = "grpValidEntries";
			this.grpValidEntries.Size = new System.Drawing.Size(582, 80);
			this.grpValidEntries.TabIndex = 2;
			this.grpValidEntries.TabStop = false;
			this.grpValidEntries.Text = "Valid Entries";
			// 
			// lblValidEntries
			// 
			this.lblValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblValidEntries.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblValidEntries.Location = new System.Drawing.Point(8, 20);
			this.lblValidEntries.Name = "lblValidEntries";
			this.lblValidEntries.Size = new System.Drawing.Size(562, 56);
			this.lblValidEntries.TabIndex = 0;
			this.lblValidEntries.Text = "Valid Entries...";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(578, 480);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// pnlWorklistBuilder
			// 
			this.pnlWorklistBuilder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlWorklistBuilder.Controls.Add(this.worklistBuilder1);
			this.pnlWorklistBuilder.Location = new System.Drawing.Point(0, 32);
			this.pnlWorklistBuilder.Name = "pnlWorklistBuilder";
			this.pnlWorklistBuilder.Size = new System.Drawing.Size(742, 444);
			this.pnlWorklistBuilder.TabIndex = 0;
			// 
			// worklistBuilder1
			// 
			this.worklistBuilder1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.worklistBuilder1.CheckBoxes = true;
			this.worklistBuilder1.Location = new System.Drawing.Point(4, 0);
			this.worklistBuilder1.Name = "worklistBuilder1";
			this.worklistBuilder1.Size = new System.Drawing.Size(734, 440);
			this.worklistBuilder1.TabIndex = 0;
			this.worklistBuilder1.InvalidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ValidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.SelectBtnClick += new System.EventHandler(this.worklistBuilder1_SelectBtnClick);
			this.worklistBuilder1.SearchClick += new System.EventHandler(this.worklistBuilder1_SearchClick);
			this.worklistBuilder1.CheckBoxesChanged += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.UnitsInList += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ItemCheck += new System.EventHandler(this.worklistBuilder1_ItemCheck);
			// 
			// pnlPhenotype
			// 
			this.pnlPhenotype.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPhenotype.Controls.Add(this.pnlAntiseraResults);
			this.pnlPhenotype.Controls.Add(this.grpImage);
			this.pnlPhenotype.Controls.Add(this.tabAntisera);
			this.pnlPhenotype.Location = new System.Drawing.Point(0, 28);
			this.pnlPhenotype.Name = "pnlPhenotype";
			this.pnlPhenotype.Size = new System.Drawing.Size(742, 448);
			this.pnlPhenotype.TabIndex = 1;
			this.pnlPhenotype.Visible = false;
			// 
			// printDialog1
			// 
			this.printDialog1.AllowPrintToFile = false;
			// 
			// FrmRecordPhenotypeResults
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 505);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.pnlPhenotype);
			this.Controls.Add(this.pnlWorklistBuilder);
			this.hlphelpChm.SetHelpKeyword(this, "Unit_Antigen_Typing.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(650, 450);
			this.Name = "FrmRecordPhenotypeResults";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Unit Antigen Typing";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmRecordPhenotypeResults_Closing);
			this.Load += new System.EventHandler(this.FrmRecordPhenotypeResults_Load);
			this.Controls.SetChildIndex(this.pnlWorklistBuilder, 0);
			this.Controls.SetChildIndex(this.pnlPhenotype, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.tabAntisera.ResumeLayout(false);
			this.pnlAntiseraResults.ResumeLayout(false);
			this.grpKey.ResumeLayout(false);
			this.grpValidEntries.ResumeLayout(false);
			this.pnlWorklistBuilder.ResumeLayout(false);
			this.pnlPhenotype.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Initialize properties of user controls
		/// </summary>
		private void SetComponentProperties()
		{
            this.LockController.LockFunction = Common.LockFunctions.UC041RecordPhenotypeResults;

			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ",string.Empty);
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.FrmRecordPhenotypeResults_Units());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.tabAntisera.TabPages.Clear();
			//
			this.dgPhenotype.InvalidateResultsButton.Click += new System.EventHandler(this.InvalidateResults);

			//set the Locking eventhandler -- TODO: set this up so it can be done in the designer or automatically
			this.dgPhenotype.UserActivity += new EventHandler(this.ResetLockTimer);
			_alWorkloadProcessIds = new ArrayList();
		}

		/// <summary>
		/// Configure data grid display to include units and check if reagent QC grid is required on test date
		/// </summary>
		/// <param name="dtUnits">Blood Units data table</param>
		/// <param name="partiallyCompleted">Partially completed worklist indicator</param>
		private void ConfigureGridDisplay(DataTable dtUnits,bool partiallyCompleted)
		{
			_taskStatus = new Hashtable();
			//
			foreach (DataRow dr in this._dtAntiseraWorklistTypings.Rows)
			{
				//
				DataSet dsPhenotype = new DataSet(dr[Common.VbecsTables.ReagentType.ReagentTypeName].ToString());
				//
				if (Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
				{
					//Show Weak D grid only
					DataTable dtWeakD = this.dgPhenotype.CreateWeakDDataTable(dtUnits,dr);
					dsPhenotype.Tables.Add(dtWeakD);
				}
				else
				{
					DataTable dtPhenotype = this.dgPhenotype.CreatePhenotypeDataTable(dtUnits,dr);
					dsPhenotype.Tables.Add(dtPhenotype);
					//
					DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)dr[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
					DataTable dtWorklistQCControls = BOL.AntiseraWorklist.GetAntiseraWorklistQCControls((Guid)dr[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
					//
					if (dtWorklistQCResults.Rows.Count == 0)
					{
						//QC not part of worklist - disable Pos & Neg QC rows
						dsPhenotype.Tables.Add(this.dgPhenotype.CreateControlDataTable());
					}
					else
					{
						//QC part of worklist - enable Pos & Neg QC rows
						dsPhenotype.Tables.Add(this.dgPhenotype.CreateControlDataTable(dr,dtWorklistQCResults,dtWorklistQCControls));
					}
					//
				}
				//
				_dsPhenotypeGrids.Add(dsPhenotype);
				_taskStatus.Add(Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId]),Common.TaskStatus.PartiallyCompleted);
			}
			//
			_activeReagent = 0;
			this.DisplaySelectedReagent();
		}

		/// <summary>
		/// Create tab pages for each of the uncompleted reagent types being tested
		/// Implements BR_41.07
		/// </summary>
		public void CreateTabs()
		{
			_dsPhenotypeGrids = new ArrayList();
			_activeReagent = 0;
			//
			//CR 2754 CR 2844 modified for loop to fix the crash when one of the tests is completed
			for(int i=0; i<this._dtAntiseraWorklistTypings.Rows.Count; i++)
			{
				DataRow dr = this._dtAntiseraWorklistTypings.Rows[i];
				//Don't add tab if this AntiseraWorklistTyping entry is complete
				if (AntiseraWorklistTypingCompleted((Guid)dr[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]))
				{
					this._dtAntiseraWorklistTypings.Rows.Remove(dr);
					i--;
					continue;
				}
				//
				TabPage page = new TabPage();
				string testName = (BOL.ReferenceData.GetOrderableTest(Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId]))[Common.VbecsTables.OrderableTest.OrderableTestName]).ToString();
				//Remove AG from start of name
				if (testName.StartsWith("AG"))
				{
					page.Text = testName.Substring(2,testName.Length-2);
				}
				page.Tag = dr;
				this.tabAntisera.TabPages.Add(page);
			}
			//
			this._drAntiseraWorklistTyping = (DataRow)tabAntisera.SelectedTab.Tag;
		}

		/// <summary>
		/// Determine if an antigen typing task is complete.
		/// </summary>
		/// <param name="antiseraWorklistTypingGuid"></param>
		/// <returns></returns>
		private bool AntiseraWorklistTypingCompleted(Guid antiseraWorklistTypingGuid)
		{
			DataTable qcResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults(antiseraWorklistTypingGuid);
//			
			foreach(DataRow qcResult in qcResults.Rows)
			{
				if ((qcResult[Common.VbecsTables.RackTest.RackTestResult].ToString().Trim().Length==0)||
					(qcResult.IsNull(Common.VbecsTables.RackLot.SatisfactoryResultIndicator)))
				{
					return false;
				}
				
			}
			//
			foreach(DataRow unit in this._dtUnits.Rows)
			{
				DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)unit[Common.VbecsTables.BloodUnit.BloodUnitGuid],antiseraWorklistTypingGuid);
				foreach(DataRow result in results.Rows)
				{
					if (result[Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim().Length==0)
					{
						return false;
					}
				}
			}
			//
			return true;
		}

		/// <summary>
		/// Blood Unit worklist builder item check event handler, enables OK button
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_ItemCheck(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this.worklistBuilder1.SelectedItems > 0);
		}
		
		/// <summary>
		///  Searches for new limited blood units to add to the worklist builder.
		///  If Weak D is in the worklist, restrict to Rh Positive units
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e"> Event args</param>
		private void worklistBuilder1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				DlgSelectBloodUnits unitSelector = null;
				try
				{
					bool weakDIncluded = false;
					foreach(DataRow dr in this._dtAntiseraWorklistTypings.Rows)
					{
						if (Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
						{
							weakDIncluded = true;
							break;
						}
					}
					//
					System.Data.DataTable phenotypeUnits = BOL.BloodUnit.GetPhenotypeUnits(LogonUser.LogonUserDivisionCode,weakDIncluded);
					
					unitSelector = new DlgSelectBloodUnits(phenotypeUnits, this.worklistBuilder1.bloodUnitSelector1.EnteredEyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.EnteredUnitProductCode);
					unitSelector.MultiSelect = true;
					unitSelector.TitleBarText = "VBECS - Select Units for Antigen Typing";
					unitSelector.LogoBarText = unitSelector.TitleBarText.Replace("VBECS - ",string.Empty);
					unitSelector.ShowDialogFromLockedParent(this, false);
				}
				catch (Exception)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.SearchToolError("unit"));
					return;
				}
				//
				if (unitSelector.DialogResult == DialogResult.OK)
				{
					this.worklistBuilder1.ResetSelectorFieldsAndErrors();
					if (unitSelector.SelectedUnits.Rows.Count > 1)
					{
						//this._bloodUnitGuids = new System.Guid [unitSelector.SelectedUnits.Rows.Count];
						//int nCtr= 0;
						foreach (DataRow dr in unitSelector.SelectedUnits.Rows)
						{
							System.Guid bloodUnitGuid = (System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid];
							//
							this.worklistBuilder1.PopulateGrid(new BOL.BloodUnit(bloodUnitGuid));
							//this._bloodUnitGuids[nCtr] = bloodUnitGuid;
							//nCtr ++;
						}

					}
					else
					{
						if (unitSelector.SelectedUnits.Rows.Count == 1)
						{
							DataRow dr = unitSelector.SelectedUnits.Rows[0];
							this.worklistBuilder1.bloodUnitSelector1.PopulateSelector(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(),
																					dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
						}
					}
				}
			}
		}

		/// <summary>
		/// Worklist Builder IsValid/IsInvalid event handler, enabled OK button.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = (this.worklistBuilder1.SelectedBloodBags.Rows.Count>0);
		}

		/// <summary>
		/// Checks if testing results are valid and displays errors as tooltip on OK buttonn.
		/// </summary>
		private void CheckTestingValid()
		{
			string caption = string.Empty;
			btnOK.EnabledButton =  (this.dgPhenotype.CheckValid(ref caption));
			btnOK.SetToolTip(caption);
		}

		/// <summary>
		/// If the worklist builder is the visible, fill the datagrid with the selected blood
		/// units that need to be tested.  If the datagrid is visible, confirm the blood unit
		/// tests and save them if they are confirmed.
		/// Implements BR_41.16
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			bool partiallyTested = this.dgPhenotype.TaskStatus == Common.TaskStatus.PartiallyCompleted;
			//
			if (pnlWorklistBuilder.Visible)
			{
				DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("Antigen typing worklist"));
				if (_saveResult != DialogResult.Yes)
				{
					return;
				}
				//
				this._bloodUnitGuids = new System.Guid [this.worklistBuilder1.SelectedBloodBags.Rows.Count];
				int nCtr= 0;

				//CR1939 - Lock just the busGuids to avoid creating the Worklist if the units are locked
				foreach (DataRow dr in this.worklistBuilder1.SelectedBloodBags.Rows)
				{
					this._bloodUnitGuids[nCtr] = (System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid];

					//CR1939 - UC_41 locks the BloodUnitStatus record - the worklist builder isn't coded to easily handle adding new 
					//         fields, so I've had to resort to creating a BloodUnitStatus object to get the Guid
					//TODO     SEE SelectedBloodBags property for update when BloodUnitStatus fix is applied
					BOL.BloodUnitStatus tmpBUS = new gov.va.med.vbecs.BOL.BloodUnitStatus(this._bloodUnitGuids[nCtr]);
                    this.LockController.RecordGuids.Add(tmpBUS.BloodUnitStatusGuid);

					nCtr ++;
				}

				//CR1939 - Check the BUS locks first, since we know the Guids and the Worklist doesn't exist yet
				if (!this.SetLocks())
					return;				//The unit locks failed, let the user select different units
				
				//
				//Need to save exceptions here...
				
				//
				try
				{
					if (this._antiseraWorklist.Save(this._dtAntiseraWorklistTypings,this.worklistBuilder1.SelectedBloodBags, _antiseraWorklist.WorklistName, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, this._bloodUnitGuids, this._antiDControlGuid, this._antiDControlComment, partiallyTested))
					{	//Save worked - new AUT GUids were created - BOL.AntiseraWorklist.GetANWorklistDetails() 
						pnlPhenotype.Visible = true;
						this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.FrmRecordPhenotypeResults_Typing());
						pnlWorklistBuilder.Visible = false;
						//
						//Need to retrieve antisera worklist after saving it for RowVersion...
						this._antiseraWorklist = new BOL.AntiseraWorklist(this._antiseraWorklist.AntiseraWorklistGuid);
						this._dtAntiseraWorklistTypings = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(this._antiseraWorklist.AntiseraWorklistGuid);
						//Moved this up before locking - FOR locking
						this._dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(this._antiseraWorklist.AntiseraWorklistGuid);

                        this.CollectRecordGuidsForLocking(this._dtAntiseraWorklistTypings);

                        //Even though we JUST created the tests, we have to lock them now to avoid conflict. this SHOULD never fail
						if (!this.SetLocks())
							return;			//What should be done?  The records are saved?

						CreateTabs();
					
						ConfigureGridDisplay(this._dtUnits,false);
						this.btnOK.EnabledButton = false;
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Antigen Typing worklist"));
						return;
					}
				}
				catch (Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
			}
			else
			{
				//CR 2792 Additional check to see if data on the grid are valid
				CheckTestingValid();
				if (this.btnOK.EnabledButton == false)
					return;
				
				if(!partiallyTested)
				{
					switch((Common.ReactivityPhase)System.Convert.ToInt32((_drAntiseraWorklistTyping[Common.VbecsTables.RackLot.ReactivityPhaseCode])))
					{
							//1) IS, 6) AHG/CC
						case Common.ReactivityPhase.IS: case Common.ReactivityPhase.AHGandCC:
							_alWorkloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase);
							break;
							//4) IS/RT, 5) IS/37, 8) 37/AHG/CC
						case Common.ReactivityPhase.ISandRT: case Common.ReactivityPhase.ISand37: case Common.ReactivityPhase.ThreeSevenandAHG:
							_alWorkloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
							break;
					}
				}
				//
				//BR_41.16
				//
				DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("Antigen typing"));
				if (_saveResult != DialogResult.Yes)
				{
					return;
				}
				
				//
				DataSet ds = (DataSet)this._dsPhenotypeGrids[this.tabAntisera.SelectedIndex];
				if (Convert.ToInt32(_drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
				{
					if (!BOL.BloodUnitTest.SaveWeakDBloodUnitTests((Guid)_drAntiseraWorklistTyping[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],_antiseraWorklist,ds.Tables["WeakD"], Common.UpdateFunction.UC041FrmRecordPhenotypeResults, this._alWorkloadProcessIds, this._bloodUnitGuids))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Weak D Typing results"));
						return;
					}
				}
				else
				{
					//Need to save exceptions here...
					//ds.Tables["Control"]["OverrideComment"] - 2 rows, Row 1 = Pos Ctrl, Row 2 = Neg
					//
					if ((ds.Tables["Control"] != null) && (ds.Tables["Control"].Rows.Count>0))
					{
						if(!partiallyTested)
						{
							switch((Common.ReactivityPhase)System.Convert.ToInt32((_drAntiseraWorklistTyping[Common.VbecsTables.RackLot.ReactivityPhaseCode])))
							{
									//1) IS, 6) AHG/CC
								case Common.ReactivityPhase.IS: case Common.ReactivityPhase.AHGandCC:
									_alWorkloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingSingleTestPhaseQC);
									break;
									//4) IS/RT, 5) IS/37, 8) 37/AHG/CC
								case Common.ReactivityPhase.ISandRT: case Common.ReactivityPhase.ISand37: case Common.ReactivityPhase.ThreeSevenandAHG:
									_alWorkloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
									break;
							}
						}
					}
					//
					try
					{
						if (!BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)_drAntiseraWorklistTyping[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],_antiseraWorklist,ds.Tables["Phenotype"],ds.Tables["Control"], _drAntiseraWorklistTyping[Common.VbecsTables.RackLot.ReactivityPhaseCode].ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, this._alWorkloadProcessIds, this._bloodUnitGuids, partiallyTested))
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Antigen Typing results"));
							return;
						}
						bool bMsgNeeded = false;
						System.Data.DataTable dt = null;
						if(this._alWorkloadProcessIds != null)
						{
							foreach(Common.WorkloadProcessID workloadPID in this._alWorkloadProcessIds)
							{
								//CR 1441
								dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) workloadPID);
								if(dt!= null && workloadPID != Common.WorkloadProcessID.Unknown)
								{
									if(dt.Rows.Count == 0)
									{
										bMsgNeeded = true;
									}
								}
							}
						}
						if (bMsgNeeded) GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
					}
					catch (Common.RowVersionException)
					{
						this.btnOK.RowVersionException = true;		//CR2077
						GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
						return;
					}
				}
				//
				this._changesSaved = true;
				this._taskStatus[Convert.ToInt32(_drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId])] = this.dgPhenotype.TaskStatus;
				//
				int remove = this.tabAntisera.SelectedIndex;
				this._dsPhenotypeGrids.RemoveAt(remove);
				this.tabAntisera.TabPages.RemoveAt(remove);
				//
				if (this.tabAntisera.TabCount==0)
				{
					//If no tests, not dirty, close window.
					this.IsDirty=false;
					this.Close();
				}
				//
				this.tabAntisera_SelectedIndexChanged(sender,e);
			}
		}

		/// <summary>
		/// Display details of the reagent that applies to the active data grid cell
		/// </summary>
		private void DisplaySelectedReagent()
		{
			DataSet dsPhenotype = (DataSet)this._dsPhenotypeGrids[_activeReagent];
			if (Convert.ToInt32(this._drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
			{
				this.dgPhenotype.SetPhenotypeDataSource();
				this.dgPhenotype.SetControlDataSource();
				this.dgPhenotype.SetWeakDDataSource(dsPhenotype.Tables["WeakD"]);
				if (this.pnlAntiseraResults.Visible)
				{
					this.dgPhenotype.FocusWeakDGrid();
				}
			}
			else
			{
				this.dgPhenotype.SetPhenotypeDataSource(dsPhenotype.Tables["Phenotype"]);
				this.dgPhenotype.SetControlDataSource(dsPhenotype.Tables["Control"]);
				this.dgPhenotype.SetWeakDDataSource();
				if (this.pnlAntiseraResults.Visible)
				{
					this.dgPhenotype.FocusPhenotypeGrid();
				}
			}
			//
			this._taskStatus[Convert.ToInt32(this._drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId])] = this.dgPhenotype.TaskStatus;
		}

		/// <summary>
		/// btnCancel click event handler, closes form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// tabAntisera selected index changed event handler, refresh selected reagent display
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void tabAntisera_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.tabAntisera.SelectedIndex>-1)
			{
				//CR 2864 setting the flag when tab switching occurs
				this.dgPhenotype.UserSwitchingTabs = true;

				_activeReagent = tabAntisera.SelectedIndex;
				this._drAntiseraWorklistTyping = (DataRow)tabAntisera.SelectedTab.Tag;
				this.DisplaySelectedReagent();
			
				//CR 2864
				this.dgPhenotype.UserSwitchingTabs = false;
			}
		}

		/// <summary>
		/// dgPhenotype data grid current cell changed event handler, refresh valid entries info
		/// based on active cell
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void dgPhenotype_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblValidEntries.Text = this.dgPhenotype.ValidEntries;
			//
			this.CheckTestingValid();
			//Cell value has changed, page is now dirty.
			this.IsDirty=true;
		}

		/// <summary>
		/// worklist builder select button click event handler. Checks if selected
		/// unit is valid for selection before selecting.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SelectBtnClick(object sender, System.EventArgs e)
		{
			BOL.BloodUnit unit = this.worklistBuilder1.bloodUnitSelector1.BloodUnit;
			//
			//BR_5.03
			if (unit.BloodUnitStatus.IsFinal())
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnitInFinalStatus());
				this.worklistBuilder1.bloodUnitSelector1.Clear(false);
				//throw an exception to stop the unit being added
				throw new Exception();
			}
			//
			//BR_41.10
			if (!BOL.AntigenTyping.CanUnitBeAntigenTyped(unit))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.WholeBloodAndRedBloodCellsOnly());
				this.worklistBuilder1.bloodUnitSelector1.Clear(false);
				//throw an exception to stop the unit being added
				throw new Exception();
			}
			//
			//BR_41.11
			foreach(DataRow dr in this._dtAntiseraWorklistTypings.Rows)
			{
				if ((Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD) && (unit.BloodUnitMedia.AboRh.RHFactorCode.Trim() == "P"))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC041.WeakDRhPositive());
					this.worklistBuilder1.bloodUnitSelector1.Clear(false);
					//throw an exception to stop the unit being added
					throw new Exception();
				}
				//
//				//BR_2.40
//				if (BOL.AntiseraWorklist.IsBloodUnitOnPendingAntiseraWorklist(unit.BloodUnitGuid,Convert.ToInt32(dr[Common.VbecsTables.OrderableTest.OrderableTestId])))
//				{
//					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC041.UnitOnPendingAntiseraWorklist(unit.EyeReadableUnitId));
//					this.worklistBuilder1.bloodUnitSelector1.Clear(false);
//					//throw an exception to stop the unit being added
//					throw new Exception();
//				}
			}
		}

		/// <summary>
		/// dgPhenotype Invalidate Results button click event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void InvalidateResults(object sender, System.EventArgs e)
		{

			DlgOverrideComment dlgOverride = new DlgOverrideComment("Invalidate Results","Enter a comment to invalidate previously entered test results","UT");
            dlgOverride.ShowDialogFromLockedParent(this, false);
			
            if (dlgOverride.DialogResult!= DialogResult.OK) return;

            //
			DataSet dsPhenotype = (DataSet)this._dsPhenotypeGrids[_activeReagent];
			dsPhenotype.Tables.Clear();
			//
			if (Convert.ToInt32(_drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
			{
				if (!this._antiseraWorklist.InvalidateWeakDTestResults(_drAntiseraWorklistTyping,_dtUnits, Common.UpdateFunction.UC041FrmRecordPhenotypeResults,dlgOverride.Comment))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotInvalidated("Weak D Typing results"));
					return;
				}
				DataTable dtWeakD = this.dgPhenotype.CreateWeakDDataTable(_dtUnits,_drAntiseraWorklistTyping);
				dsPhenotype.Tables.Add(dtWeakD);
			}
			else
			{

				if (!this._antiseraWorklist.InvalidateAntigenTypingTestResults(_drAntiseraWorklistTyping,_dtUnits, Common.UpdateFunction.UC041FrmRecordPhenotypeResults,dlgOverride.Comment))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotInvalidated("Antigen Typing results"));
					return;
				}
				
				dsPhenotype.Tables.Add(this.dgPhenotype.CreatePhenotypeDataTable(_dtUnits,_drAntiseraWorklistTyping));
				//
				DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)_drAntiseraWorklistTyping[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
				DataTable dtWorklistQCControls = BOL.AntiseraWorklist.GetAntiseraWorklistQCControls((Guid)_drAntiseraWorklistTyping[Common.VbecsTables.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
				//
				if (dtWorklistQCResults.Rows.Count == 0)
				{
					//QC not part of worklist - disable Pos & Neg QC rows
					dsPhenotype.Tables.Add(this.dgPhenotype.CreateControlDataTable());
				}
				else
				{
					//QC part of worklist - enable Pos & Neg QC rows
					dsPhenotype.Tables.Add(this.dgPhenotype.CreateControlDataTable(_drAntiseraWorklistTyping,dtWorklistQCResults,dtWorklistQCControls));
				}
			}
			//
			this.DisplaySelectedReagent();
			this.btnOK.EnabledButton = false;
		}

        /// <summary>
        /// Adds the guids of all the Selected AntiseraWorklistTypingGuids
        /// </summary>
        /// <param name="dtLocks">DataTable of the AntiseraWorklistTYping information</param>
        /// <returns></returns>
        private void CollectRecordGuidsForLocking(System.Data.DataTable dtLocks)
        {
            System.Collections.ArrayList guidArray = new ArrayList();

            foreach (System.Data.DataRow drTest in dtLocks.Rows)
            {
                this.LockController.RecordGuids.Add((System.Guid)drTest[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
            }

            foreach (System.Data.DataRow drUnit in this._dtUnits.Rows)
            {
                this.LockController.RecordGuids.Add((System.Guid)drUnit[TABLES.BloodUnitStatus.BloodUnitStatusGuid]);
            }
        }

		/// <summary>
		/// FrmRecordPhenotypeResults closing event handler, checks if worklist task status
		/// should be completed
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void FrmRecordPhenotypeResults_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (!this.pnlWorklistBuilder.Visible)
			{
				//Changes to test results were saved, so we might need to update the task status
				//to partially completed or completed.
				if (this._changesSaved)
				{
					try
					{
						Common.TaskStatus taskStatus = Common.TaskStatus.Completed;
						if (this._taskStatus.ContainsValue(Common.TaskStatus.PartiallyCompleted))
						{
							taskStatus = Common.TaskStatus.PartiallyCompleted;
						}
						//
						if (!this._antiseraWorklist.UpdateTaskStatus(taskStatus))
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UpdateFailed("Worklist status"));
							return;
						}
					}
					catch(RowVersionException)
					{
						//CR2077?
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					}
				}
			}
		}

		/// <summary>
		/// btnCancel mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_MouseHover(object sender, System.EventArgs e)
		{
			this.ttToolTip.SetToolTip(btnCancel,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn().ResString);
		}

		/// <summary>
		/// btnOK mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.pnlPhenotype.Visible)
			{
				if (this.btnOK.EnabledButton)
				{
					btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				}
				else
				{
					string caption = string.Empty;
					this.dgPhenotype.CheckValid(ref caption);
					if (caption.Trim().Length==0)
					{
						caption = Common.StrRes.Tooltips.Common.NoChangesToSave().ResString;
					}
					btnOK.SetToolTip(caption);
				}
			}
			else
			{
				if (this.btnOK.EnabledButton)
				{
					btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
				}
				else
				{
					btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);
				}
			}
		}

		private void FrmRecordPhenotypeResults_Load(object sender, System.EventArgs e)
		{
			if (this.pnlAntiseraResults.Visible)
			{
				//
				this.btnOK.EnabledButton = false;
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.FrmRecordPhenotypeResults_Typing());
				//
				DataSet dsPhenotype = (DataSet)this._dsPhenotypeGrids[_activeReagent];
				if (Convert.ToInt32(this._drAntiseraWorklistTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
				{
				
					this.dgPhenotype.FocusWeakDGrid();
				}
				else
				{
					this.dgPhenotype.FocusPhenotypeGrid();
				}
			}
		}
	}
}

